import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/data.dart';
import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/user_editor_page.dart';

class UserCredentialsSection extends StatelessWidget {
  const UserCredentialsSection({Key? key}) : super(key: key);

  @override
  build(context) {
    return UserEditorPage(
      heading: 'Credentials',
      description: 'Careful - User can loose access to their account, if you change below information.',
      fields: [
        UserField(
          key: UserTable.username,
          type: FieldType.text,
          leading: 'Username',
          placeholder: 'Username',
        ),
        UserField(
          key: UserTable.email,
          type: FieldType.text,
          leading: 'Email',
          placeholder: 'Email address',
        ),
      ],
    );
  }
}
